package mole.entities.controlers
{
	import mole.entities.items.IItem;
	import mole.entities.CPlayer;
	import net.flashpunk.FP;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	
	/**
	 * Controlleur d'un joueur humain.
	 * @author Cédric Liaudet
	 */
	public class CPlayerControler2 implements IControler
	{		
		/**
		 * Constructeur par défaut.
		 */
		public function CPlayerControler2() 
		{			
			// Déplacements
			Input.define("jump2", Key.O);
			Input.define("down2", Key.P);
		}
		
		/**
		 * Callback de mise à jours du controlleur.
		 */
		public function update(_Player:CPlayer):void
		{
			// Saut
			if (Input.pressed("jump2"))
			{
				_Player.OnJump();
			}
			else if (Input.released("jump2"))
			{
				_Player.ReleaseJump();
			}
			
			// Accroupie.
			if (Input.pressed("down2"))
			{
				_Player.OnDown();
			}
			else if (Input.released("down2"))
			{
				_Player.OnUp();
			}
		}
		
		/**
		 * Renvoie la vitesse du controlleur.
		 * @return La vitesse du controlleur.
		 */
		public function GetSpeed():int
		{
			return 0;
		}
	}

}